//###############################################################
// PresetDlg.cpp : Dialog of Preset point parameter.
//
// S_PresetDlg			: Create and show the preset parameter dialog
// S_CreatePresetDlg()	:
// S_PresetEditSave()	: PresetDlg Edit Save
//###############################################################

#include "stdafx.h"
#include "Define.h"
#include "stdio.h"
#include "SpeedDome.h"
#include "misc.h"
#include "comm.h"
#include "Preset.h"
#include "GlobalVar.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


//###############################################################
//
// PresetDlg dialog
//
//###############################################################

CPresetDlg::CPresetDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CPresetDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CPresetDlg)
	m_nPanDeg = 0.0f;
	m_nTiltDeg = 0.0f;
	m_nFocus = 0;
	m_nZoom = 0;
	//}}AFX_DATA_INIT
}


void CPresetDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CPresetDlg)
	DDX_Text(pDX, IDC_PRESET_PAN_DEG, m_nPanDeg);
	DDV_MinMaxFloat(pDX, m_nPanDeg, 0.f, 360.f);
	DDX_Text(pDX, IDC_PRESET_TILT_DEG, m_nTiltDeg);
	DDV_MinMaxFloat(pDX, m_nTiltDeg, 0.f, 90.f);
	DDX_Text(pDX, IDC_PRESET_FOCUS, m_nFocus);
	DDX_Text(pDX, IDC_PRESET_ZOOM, m_nZoom);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CPresetDlg, CDialog)
	//{{AFX_MSG_MAP(CPresetDlg)
	//}}AFX_MSG_MAP
	ON_COMMAND(IDC_PT_WRITE_FILE,S_PTWriteToFile)
	ON_COMMAND(IDC_PT_WRITE_EE,S_PTWriteToEE)
	ON_COMMAND(IDC_PT_WRITE_FILE_EE,S_PTWriteToFileEE)
END_MESSAGE_MAP()


//###############################################################
// 
// OnInitDialog()	:
//
//###############################################################
BOOL CPresetDlg::OnInitDialog() 
{
CDialog::OnInitDialog();

//----------- TODO: Add extra initialization here
char			Para[10]="\x14\x00\x00\x00\x00\x00\xff\x18\x12";
char			Disp[30];
double			PanDeg=0,TiltDeg=0;
unsigned short 	Temp;
LPTSTR			NoUse;
unsigned short 	Zoom=0,Focus=0;


m_PTNum=CPreset::S_PresetIDToNum(G_RCtrlID,&NoUse);

if (G_PresetDlg->m_FileEE==1)		//--- Get parameter from file
	CPreset::S_GetPresetParaFiles(m_PTNum,Para);
else
	CPreset::S_GetPresetParaEE(m_PTNum,Para);	//--- Get parameter from EE

Para[1]=Para[1]&'\x7f';	Para[3]=Para[3]&'\x7f';

Temp=S_WORD(Para[0],Para[1]);		PanDeg=Temp*360.0/768.0;
Temp=S_WORD(Para[2],Para[3]);		TiltDeg=Temp*90.0/240.0;
Zoom=S_WORD(Para[4],Para[5]);
Focus=S_WORD(Para[6],Para[7]);

sprintf(Disp,"%-5.1f",PanDeg);		SetDlgItemText(IDC_PRESET_PAN_DEG,Disp);
sprintf(Disp,"%-5.1f",TiltDeg);		SetDlgItemText(IDC_PRESET_TILT_DEG,Disp);
sprintf(Disp,"%-4u",Zoom);			SetDlgItemText(IDC_PRESET_ZOOM,Disp);
sprintf(Disp,"%-4u",Focus);			SetDlgItemText(IDC_PRESET_FOCUS,Disp);
//-----------------------------------------------------------
return TRUE;  // return TRUE unless you set the focus to a control
	          // EXCEPTION: OCX Property Pages should return FALSE
}


//###############################################################
// 
// S_CreatePresetDlg()	:	0:EE	File:1
//
//###############################################################
void CPreset::S_CreatePresetDlg(int FileEE)
{
CPresetDlg PresetParaDlg;

PresetParaDlg.m_FileEE=FileEE;
G_PresetDlg=&PresetParaDlg;

int nResponse = PresetParaDlg.DoModal();
if (nResponse == IDOK)
	{
	switch(G_PresetDlg->m_Button)
		{	
		case IDC_PT_WRITE_FILE_EE :
				CPreset::S_PresetEditSave(2);	//--Write to File and EE
				break;
		case IDC_PT_WRITE_EE :
				CPreset::S_PresetEditSave(0);	//--Write to EE
				break;
		case IDC_PT_WRITE_FILE :
				CPreset::S_PresetEditSave(1);	//--Write to File
				break;
		}
	}
else if (nResponse == IDCANCEL)
	{	
	}

}


//###############################################################
// 
// S_PresetEditSave()	:	PresetDlg Edit Save
//
//###############################################################
void CPreset::S_PresetEditSave(UINT FileEE)
{
char	Para[10]="\x00\x00\x00\x00\x00\x00\x00\x00\x00";


CPreset::S_GetPresetParaDlg(Para);
switch (FileEE)
	{
	case 0:	CPreset::S_WritePresetParaEE(G_PresetDlg->m_PTNum,Para);
			break;
	case 1:	CPreset::S_WritePresetParaFile(G_PresetDlg->m_PTNum,Para);
			break;
	case 2:	CPreset::S_WritePresetParaEE(G_PresetDlg->m_PTNum,Para);
			CPreset::S_WritePresetParaFile(G_PresetDlg->m_PTNum,Para);
			break;
	}

}

//###############################################################
// 
// S_WrietPresetParaEE()	:	PresetDlg
//
//###############################################################
void	CPreset::S_WritePresetParaEE(UINT Num,char *Para)
{

unsigned short	TAddr=0;
unsigned char	Temp[3];
char			EEAddr[3];
UINT 			PresetNum;
LPTSTR			PresetBmpName;


PresetNum=CPreset::S_PresetIDToNum(G_RCtrlID,&PresetBmpName);
TAddr=EE_BASE_PRESET+EE_SIZE_PRESET*(PresetNum-1);


S_WordTo2Bytes(TAddr,&Temp[0],&Temp[1]);
EEAddr[0]=Temp[0];		EEAddr[1]=Temp[1];

CComm::S_COM_AccessEEData(0,EEAddr,EE_SIZE_PRESET,Para);

}

//###############################################################
// 
// S_WrietPresetParaFiles()	:	PresetDlg
//
//###############################################################
void	CPreset::S_WritePresetParaFile(UINT Num,char *Para)
{

HANDLE			hSQ,hMap;
unsigned char 	*Fptr;
UINT			Temp;

hSQ=CreateFile("Preset.rec",GENERIC_READ|GENERIC_WRITE,FILE_SHARE_WRITE,NULL,
				OPEN_EXISTING,FILE_ATTRIBUTE_NORMAL,NULL);
hMap=CreateFileMapping( hSQ,NULL,PAGE_READWRITE,0,0,NULL);
Fptr=(unsigned char *)MapViewOfFile(hMap,FILE_MAP_WRITE,0,0,0);

Num=(Num-1)*EE_SIZE_PRESET;

for(int i=0;i<=(EE_SIZE_PRESET-1);i++)
	{
	Temp=Para[i];
	if(Temp==0)
		*(Fptr+i+Num)=0xff;
	else
		*(Fptr+i+Num)=Para[i];
	}

FlushViewOfFile(Fptr,0);
UnmapViewOfFile(Fptr); 
CloseHandle(hMap);
CloseHandle(hSQ);


}

//###############################################################
// 
// S_PTWriteToFile()	:	Call func to save preset to file
//
//###############################################################
void CPresetDlg::S_PTWriteToFile()
{
m_Button=IDC_PT_WRITE_FILE;
PostMessage(WM_COMMAND,IDOK,BN_CLICKED);
}

//###############################################################
// 
// S_PTWriteToEE()	:	Call func to save preset to EE
//
//###############################################################
void CPresetDlg::S_PTWriteToEE()
{
m_Button=IDC_PT_WRITE_EE;
PostMessage(WM_COMMAND,IDOK,BN_CLICKED);
}

//###############################################################
// 
// S_PTWriteToFileEE()	:	Call func to save preset to File & EE
//
//###############################################################
void CPresetDlg::S_PTWriteToFileEE()
{
m_Button=IDC_PT_WRITE_FILE_EE;
PostMessage(WM_COMMAND,IDOK,BN_CLICKED);
}
